// priority: 20
let 启用实体战利品调试 = false; // 设置为 true 开启调试日志, 设置为 false 关闭调试日志

let 实体战利品调试日志 = (参数) => {
    if (启用实体战利品调试) {
        console.log("[实体战利品调试]", 参数);
    }
};
let 实体战利品调试警告 = (参数) => {
    if (启用实体战利品调试) {
        console.warn("[实体战利品警告]", 参数);
    }
};

LootJS.modifiers((e) => {
    实体战利品调试日志("LootJS.modifiers 开始执行");
    let 实验性玩法_开启键 = "experimentalGameplay_enabled";
    实体战利品调试日志("阶段掉落概率加成配置:", JSON.stringify(阶段掉落概率加成配置));
    Object.entries(怪物分级表).forEach(([怪物等级名称, 该等级实体ID列表]) => {
        实体战利品调试日志(`处理怪物等级: ${怪物等级名称}`);
        let 对应战利品池组 = 等级战利品池[怪物等级名称];
        if (!对应战利品池组 || typeof 对应战利品池组 !== "object") {
            实体战利品调试警告(`怪物等级 ${怪物等级名称} 的战利品池组无效或未定义，跳过。`);
            return;
        }
        if (!Array.isArray(该等级实体ID列表)) {
            实体战利品调试警告(`怪物等级 ${怪物等级名称} 的实体ID列表不是数组，跳过。`);
            return;
        }
        实体战利品调试日志(`怪物等级 ${怪物等级名称} 包含实体:`, JSON.stringify(该等级实体ID列表));
        该等级实体ID列表.forEach(实体ID => {
            if (typeof 实体ID !== "string" || 实体ID.trim() === "") {
                实体战利品调试警告(`无效的实体ID: "${实体ID}"，跳过。`);
                return;
            }
            实体战利品调试日志(`处理实体ID: ${实体ID}`);
            难度标签键名数组.forEach(难度键名 => {
                let 玩家难度阶段名 = 难度阶段前缀 + 难度键名;
                实体战利品调试日志(`处理难度键名: ${难度键名} (玩家难度阶段: ${玩家难度阶段名})`);
                let 当前难度战利品项列表 = 对应战利品池组[难度键名];
                if (!Array.isArray(当前难度战利品项列表) || 当前难度战利品项列表.length === 0) {
                    实体战利品调试日志(`难度 ${难度键名} 的战利品项列表为空或无效，跳过。`);
                    return;
                }
                实体战利品调试日志(`难度 ${难度键名} 包含战利品项:`, 当前难度战利品项列表.length, "条");
                当前难度战利品项列表.forEach((战利品项, 战利品索引) => {
                    实体战利品调试日志(`处理战利品项 #${战利品索引 + 1}:`, JSON.stringify(战利品项));
                    if (!Array.isArray(战利品项) || 战利品项.length < 3) {
                        实体战利品调试警告(`战利品项 #${战利品索引 + 1} 格式无效 (长度小于3)，跳过。`);
                        return;
                    }
                    let 掉落物品ID = 战利品项[0];
                    let 基础总掉落概率 = 战利品项[1];
                    let 数量数组 = 战利品项[2];
                    let 每点幸运增加的总概率 = 战利品项[3];
                    if (typeof 掉落物品ID !== "string" || 掉落物品ID.trim() === "") {
                        实体战利品调试警告(`战利品项 #${战利品索引 + 1} 物品ID无效，跳过。`);
                        return;
                    }
                    if (typeof 基础总掉落概率 !== "number" || isNaN(基础总掉落概率) || 基础总掉落概率 < 0 || 基础总掉落概率 > 1) {
                        实体战利品调试警告(`战利品项 #${战利品索引 + 1} 基础掉落概率无效 (${基础总掉落概率})，跳过。`);
                        return;
                    }
                    if (!Array.isArray(数量数组) || 数量数组.length !== 2 || typeof 数量数组[0] !== "number" || typeof 数量数组[1] !== "number" || isNaN(数量数组[0]) || isNaN(数量数组[1])) {
                        实体战利品调试警告(`战利品项 #${战利品索引 + 1} 数量数组格式无效 (${JSON.stringify(数量数组)})，跳过。`);
                        return;
                    }
                    if (每点幸运增加的总概率 !== undefined && (typeof 每点幸运增加的总概率 !== "number" || isNaN(每点幸运增加的总概率))) {
                        实体战利品调试日志(`战利品项 #${战利品索引 + 1} 每点幸运增加概率值无效 (${每点幸运增加的总概率})，重置为0。`);
                        每点幸运增加的总概率 = 0;
                    } else if (每点幸运增加的总概率 === undefined) {
                        实体战利品调试日志(`战利品项 #${战利品索引 + 1} 未定义每点幸运增加概率，默认为0。`);
                        每点幸运增加的总概率 = 0;
                    }
                    let 最小掉落数量 = 数量数组[0];
                    let 最大掉落数量 = 数量数组[1];
                    if (最小掉落数量 > 最大掉落数量) {
                        实体战利品调试日志(`战利品项 #${战利品索引 + 1} 最小数量大于最大数量，已修正。`);
                        最大掉落数量 = 最小掉落数量;
                    }
                    let 可选数量个数 = 最大掉落数量 - 最小掉落数量 + 1;
                    if (可选数量个数 <= 0) {
                        实体战利品调试警告(`战利品项 #${战利品索引 + 1} 计算出的可选数量个数无效 (${可选数量个数})，跳过。`);
                        return;
                    }
                    实体战利品调试日志(`战利品项 #${战利品索引 + 1} - 物品: ${掉落物品ID}, 基础P: ${基础总掉落概率}, 数量: [${最小掉落数量}-${最大掉落数量}], 每幸运P: ${每点幸运增加的总概率}`);
                    e.addEntityLootModifier(实体ID)
                        .playerPredicate(p => {
                            let 满足阶段 = p.stages && typeof p.stages.has === "function" && p.stages.has(玩家难度阶段名);
                            实体战利品调试日志(`  [PlayerPredicate 运行时] 实体: ${实体ID}, 物品: ${掉落物品ID}, 玩家: ${p.name.string}, 难度阶段: ${玩家难度阶段名}, 是否满足: ${满足阶段}`);
                            return 满足阶段;
                        })
                        .apply(context => {
                            实体战利品调试日志(`[Apply 运行时] 实体: ${实体ID}, 物品: ${掉落物品ID}, 玩家: ${context.player.name.string}`);
                            let 服务器持久数据 = context.server.persistentData;
                            let 实验性玩法是否开启 = false;
                            if (服务器持久数据 && typeof 服务器持久数据.getBoolean === "function") {
                                实验性玩法是否开启 = 服务器持久数据.getBoolean(实验性玩法_开启键);
                            }
                            实体战利品调试日志(`实验性玩法是否开启: ${实验性玩法是否开启}`);
                            if (掉落物品ID === "l2hostility:hostility_orb" && !实验性玩法是否开启) {
                                实体战利品调试日志(`物品 ${掉落物品ID} 因实验性玩法未开启而不掉落。`);
                                return;
                            }
                            let 玩家对象 = context.player;
                            let 上下文幸运值 = context.getLuck();
                            let 调整后的总掉落概率 = 基础总掉落概率;
                            实体战利品调试日志(`  初始调整概率 (基础): ${调整后的总掉落概率}`);
                            if (每点幸运增加的总概率 > 0) {
                                let 幸运带来的增加 = 上下文幸运值 * 每点幸运增加的总概率;
                                调整后的总掉落概率 += 幸运带来的增加;
                                实体战利品调试日志(`幸运值: ${上下文幸运值}, 幸运增加概率: ${幸运带来的增加}, 调整后(含幸运): ${调整后的总掉落概率}`);
                            }
                            let 最高有效生物强化阶段名 = null;
                            if (玩家对象 && 玩家对象.stages && typeof 玩家对象.stages.has === "function" && global.生物强化全局配置 && Array.isArray(global.生物强化全局配置.动态阶段优先级)) {
                                for (let 阶段 of global.生物强化全局配置.动态阶段优先级) {
                                    if (玩家对象.stages.has(阶段)) {
                                        最高有效生物强化阶段名 = 阶段;
                                        实体战利品调试日志(`玩家 ${玩家对象.name.string} 拥有生物强化阶段: ${阶段} (作为最高有效阶段)`);
                                        break;
                                    }
                                }
                                if (!最高有效生物强化阶段名) {
                                    实体战利品调试日志(`玩家 ${玩家对象.name.string} 没有在优先级列表中的生物强化阶段。`);
                                }
                            } else {
                                实体战利品调试日志(`无法获取玩家生物强化阶段 (玩家对象、stages、或全局配置缺失)。`);
                            }
                            if (最高有效生物强化阶段名 && 阶段掉落概率加成配置[最高有效生物强化阶段名] !== undefined) {
                                let 阶段加成百分比 = 阶段掉落概率加成配置[最高有效生物强化阶段名];
                                let 原始概率 = 调整后的总掉落概率;
                                调整后的总掉落概率 = 调整后的总掉落概率 * (1 + 阶段加成百分比);
                                实体战利品调试日志(`生物强化阶段 ${最高有效生物强化阶段名} 提供加成: ${阶段加成百分比 * 100}%, 调整前P: ${原始概率}, 调整后P: ${调整后的总掉落概率}`);
                            } else if (最高有效生物强化阶段名) {
                                实体战利品调试日志(`生物强化阶段 ${最高有效生物强化阶段名} 在加成配置中未定义。`);
                            }
                            调整后的总掉落概率 = Math.max(0.0, Math.min(1.0, 调整后的总掉落概率));
                            实体战利品调试日志(`  最终概率 (限定0-1后): ${调整后的总掉落概率}`);
                            let 随机数总概率 = Math.random();
                            let 是否掉落该物品 = 随机数总概率 < 调整后的总掉落概率;
                            实体战利品调试日志(`随机数: ${随机数总概率}, 是否掉落 (${掉落物品ID}): ${是否掉落该物品}`);
                            if (是否掉落该物品) {
                                let 掉落数量 = 最小掉落数量 + Math.floor(Math.random() * 可选数量个数);
                                实体战利品调试日志(`成功掉落 ${掉落物品ID} x ${掉落数量}`);
                                context.addLoot(Item.of(掉落物品ID).withCount(掉落数量));
                            }
                        });
                });
            });
        });
    });

    for (let 实体ID in 移除生物掉落配置) {
        let 物品列表 = 移除生物掉落配置[实体ID];
        if (Array.isArray(物品列表)) {
            物品列表.forEach(物品ID => {
                e.addEntityLootModifier(实体ID)
                    .removeLoot(物品ID);
            });
        }
    }

    禁止掉落物品.forEach(物品ID => {
        e.addLootTypeModifier(LootType.ENTITY)
            .removeLoot(物品ID);
    });

    抢夺影响掉落配置.forEach(规则 => {
        let [实体ID, 物品ID, 基础概率, 每级抢夺增加概率, 数量数组] = 规则;
        let [最小数量, 最大数量] = 数量数组;
        e.addEntityLootModifier(实体ID)
            .randomChanceWithLooting(基础概率, 每级抢夺增加概率)
            .addLoot(
                Item.of(物品ID).withNBT({
                    LootFunctions: [
                        {
                            function: "minecraft:set_count",
                            count: {
                                type: "minecraft:uniform",
                                min: 最小数量,
                                max: 最大数量
                            }
                        }
                    ]
                })
            );
    });

实体战利品配置.forEach(配置条目 => {
        // 使用新的解构赋值, 直接获取实体ID和物品列表
        let [
            实体ID,
            物品列表, // 现在这是一个包含多个物品信息的数组
            行为类型,
            玩家击杀
        ] = 配置条目;

        // 默认值处理保持不变
        行为类型 = (行为类型 !== undefined) ? 行为类型 : "追加";
        玩家击杀 = (玩家击杀 !== undefined) ? 玩家击杀 : true;

        let 修改器 = e.addEntityLootModifier(实体ID);

        if (行为类型 === "覆盖") {
            修改器.removeLoot(Ingredient.all);
        }

        if (玩家击杀) {
            修改器.killedByPlayer();
        }

        // apply内部的逻辑是主要修改点
        修改器.apply(context => {
            // 遍历配置中的"物品列表"
            物品列表.forEach(物品详情 => {
                // 解构获取单个物品的ID和数量范围
                let [物品ID, 最小数量, 最大数量] = 物品详情;

                let 实际掉落数量;
                // 计算随机掉落数量的逻辑保持不变
                if (最小数量 >= 最大数量) { // 使用 >= 防止意外情况
                    实际掉落数量 = 最小数量;
                } else {
                    let 可选数量个数 = 最大数量 - 最小数量 + 1;
                    实际掉落数量 = 最小数量 + Math.floor(Math.random() * 可选数量个数);
                }

                // 如果计算出的数量大于0, 就添加到战利品中
                if (实际掉落数量 > 0) {
                    context.addLoot(Item.of(物品ID).withCount(实际掉落数量));
                }
            });
        });
    });
});